#!/usr/bin/perl
############################################
## This software is licensed under the LGPL.
## Visit http://solar.js.cx for more info.
############################################
#!!! This file modified by Alan Dunwell - http://dunwellguitar.com/solardata/
# look for the #!!! flag for mods.

use Device::SerialPort;
use Mysql;
use lib '/usr/local/solar-web_monitor/cgi-bin';
use localvars;

$db = Mysql->Connect ($mysql_host, $mysql_db, $mysql_user, $mysql_passwd);
#!!!+
## Wait until unlocked. Check first for abandoned lock file.
## Test for finding the age of the file, delete if 10 min or more.
use File::stat;
use Time::localtime;
# file age number from -M is in days, so is fracional. Multiply
# by the number of minutes in a day.
$nummin = ((-M $serial_lock)*1440);
  if ($nummin >= 10) {
    unlink($serial_lock);
#    die "/tmp/ttyS1.lock file exists. File deleted.";
  }
$slpcnt = 0;
while (-e $serial_lock)
{
  sleep (1);
  $slpcnt = ($slpcnt + 1);
  $slpcnt <= 60                                         ||die "Caught in Sleep Loop. No daily log recorded";
}
#!!!-

##!!!+ Wait until unlocked - Original lines replaced by above
#while (-e $serial_lock)
#{
#  sleep (1);
#}
#!!!-

$serial_port = new Device::SerialPort ($serial_port, "", $serial_lock);

$serial_port->baudrate(9600)				|| die "failed setting baudrate";
$serial_port->parity("none")				|| die "failed setting parity";
$serial_port->databits(8)				|| die "failed setting databits";
$serial_port->handshake("none")				|| die "failed setting handshake";
$serial_port->write_settings				|| die "no settings";

## Might need to tweak this if data is truncated.
$serial_port->read_const_time(40);

$serial_port->write("KWHTODAY?\r");
($count, $xantrex_kwhtoday) = $serial_port->read(255);

$serial_port->write("TIME?\r");
($count, $xantrex_time) = $serial_port->read(255);

$db->query("insert into totals_log values (now(), $xantrex_kwhtoday, $kwh_cost, $xantrex_time)");

$serial_port->close || warn "close failed";
