#!/usr/bin/perl
############################################
## This software is licensed under the LGPL.
## Visit http://solar.js.cx for more info.
############################################
use Mysql;
use CGI;
use Device::SerialPort;
use localvars;

$db = Mysql->Connect ($mysql_host, $mysql_db, $mysql_user, $mysql_passwd);

## Wait until unlocked
while (-e $serial_lock)
{ 
  sleep (1);
}
$serial_port = new Device::SerialPort ($serial_port, "", $serial_lock);

$serial_port->baudrate(9600)				|| die "failed setting baudrate";
$serial_port->parity("none")				|| die "failed setting parity";
$serial_port->databits(8)				|| die "failed setting databits";
$serial_port->handshake("none")				|| die "failed setting handshake";
$serial_port->write_settings				|| die "no settings";

$cgi = new CGI;
print $cgi->header;

print <<html;
<TITLE>Live Xantrex Monitor</TITLE>
<meta http-equiv="refresh" content="60">
html

## Might need to tweak this if data is truncated.
$serial_port->read_const_time(40);

$serial_port->write("IDN?\r");
($count, $xantrex_idn) = $serial_port->read(255);

$serial_port->write("ROM?\r");
($count, $xantrex_rom) = $serial_port->read(255);

$serial_port->write("KWHLIFE?\r");
($count, $xantrex_kwhlife) = $serial_port->read(255);

$serial_port->write("KWHTODAY?\r");
($count, $xantrex_kwhtoday) = $serial_port->read(255);

$serial_port->write("TIME?\r");
($count, $xantrex_time) = $serial_port->read(255);

$serial_port->write("PIN?\r");
($count, $xantrex_pin) = $serial_port->read(255);

$serial_port->write("VIN?\r");
($count, $xantrex_vin) = $serial_port->read(255);

$serial_port->write("IIN?\r");
($count, $xantrex_iin) = $serial_port->read(255);

$serial_port->write("POUT?\r");
($count, $xantrex_pout) = $serial_port->read(255);

$serial_port->write("VOUT?\r");
($count, $xantrex_vout) = $serial_port->read(255);

$serial_port->write("IOUT?\r");
($count, $xantrex_iout) = $serial_port->read(255);

$serial_port->write("MEASTEMP?\r");
($count, $xantrex_meastemp) = $serial_port->read(255);

$serial_port->write("RECTIME?\r");
($count, $xantrex_rectime) = $serial_port->read(255);

$serial_port->close || warn "close failed";

$font_begin = "<FONT FACE=\"terminal\" SIZE=\"2\">";
$font_end = "</FONT>";
$cell_attr = "BGCOLOR=\"#E8E8E8\"";

if ($xantrex_pin > 0.0)
{
  $efficiency = 100 * $xantrex_pout / $xantrex_pin;
  ($num, $mantissa) = split ('\.', $efficiency);
  $mantissa = substr($mantissa, 0, 2);
  $efficiency = $num.".".$mantissa;

  $load = 100 * $xantrex_pin / $array_size;
  ($num, $mantissa) = split ('\.', $load);
  $mantissa = substr($mantissa, 0, 2);
  $load = $num.".".$mantissa;

  $overall = 100 * $xantrex_pout / $array_size;
  ($num, $mantissa) = split ('\.', $overall);
  $mantissa = substr($mantissa, 0, 2);
  $overall = $num.".".$mantissa;
}
else
{
  $efficiency = 0.0;
  $load = 0.0;
  $overall = 0.0;
}

$avg_output = 1000 * $xantrex_kwhtoday / 24.0;
($avg_output, $mantissa) = split ('\.', $avg_output);

$output_hours = $xantrex_time / 3600;
($output_hours, $mantissa) = split ('\.', $output_hours);
$mantissa = substr($mantissa, 0, 2);
$output_hours .= ".".$mantissa;


$timestamp = scalar localtime;

print <<HTML;
<CENTER>
$font_begin Live Xantrex Monitor - $timestamp $font_end
<TABLE BGCOLOR="#000000" BORDER="0" CELLSPACING="1" CELLPADDING="3">
  <TR>
    <TD $cell_attr>$font_begin IDN $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_idn $font_end</TD>
    <TD $cell_attr>$font_begin Identification $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin ROM $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_rom $font_end</TD>
    <TD $cell_attr>$font_begin Firmware $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin KWHLIFE $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_kwhlife $font_end</TD>
    <TD $cell_attr>$font_begin kWh Produced Total$font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin KWHTODAY $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_kwhtoday $font_end</TD>
    <TD $cell_attr>$font_begin kWh Produced Today $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin TIME $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_time $font_end</TD>
    <TD $cell_attr>$font_begin Time Online Today $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin PIN $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_pin $font_end</TD>
    <TD $cell_attr>$font_begin DC Solar Power Input $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin VIN $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_vin $font_end</TD>
    <TD $cell_attr>$font_begin DC Solar Voltage Input $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin IIN $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_iin $font_end</TD>
    <TD $cell_attr>$font_begin DC Solar Current Input $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin POUT $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_pout $font_end</TD>
    <TD $cell_attr>$font_begin AC Grid Power Output $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin VOUT $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_vout $font_end</TD>
    <TD $cell_attr>$font_begin AC Grid Voltage Output $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin IOUT $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_iout $font_end</TD>
    <TD $cell_attr>$font_begin AC Grid Current Output $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin MEASTEMP $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_meastemp $font_end</TD>
    <TD $cell_attr>$font_begin Heatsink Temperature $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin RECTIME $font_end</TD>
    <TD $cell_attr>$font_begin $xantrex_rectime $font_end</TD>
    <TD $cell_attr>$font_begin Reconnection Time Remaining $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr COLSPAN="3" ALIGN="CENTER">$font_begin Supplemental Calculations $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin Efficiency $font_end</TD>
    <TD $cell_attr COLSPAN="2">$font_begin $efficiency% (POUT/PIN) $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin Load $font_end</TD>
    <TD $cell_attr COLSPAN="2">$font_begin $load% (PIN / $array_size) $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin Overall $font_end</TD>
    <TD $cell_attr COLSPAN="2">$font_begin $overall% (POUT / 1360) $font_end</TD>
  </TR>
  <TR>
    <TD $cell_attr>$font_begin 24h Avg $font_end</TD>
    <TD $cell_attr COLSPAN="2">$font_begin $avg_output watt constant draw over 24 hour period $font_end</TD>
  </TR>
</TABLE>
$font_begin (Refreshes every 60 seconds) $font_end
</CENTER>
HTML

$count = ($db->query("select count+1 from visitors"))->fetchrow;
$db->query("update visitors set count=$count");
