#!/usr/bin/perl
############################################
## This software is licensed under the LGPL.
## Visit http://solar.js.cx for more info.
############################################
#!!!+ This file has been heavily modified by Alan Dunwell - http://dunwellguitar.com
#   Look for the #!!! flag, but be aware that because of the extensive modifications,
#   not all changes might be flagged. For best information do a comparison with Justin's
#   original files. AAD
#   Last Mod - 04/02/2008 - Release-2
#!!!-

use Mysql;
use CGI;
use localvars;

$db = Mysql->Connect ($mysql_host, $mysql_db, $mysql_user, $mysql_passwd);

$cgi = new CGI;
print $cgi->header;

### Set local defs.
$power_graph_data_file = "/tmp/power_graph.dat";
$power_graph_gnuplot_file = "/tmp/power_graph.gplot";
$power_graph_line_width = 1;
$power_graph_image = "/tmp/power_graph.png";
$Flag = '0';

###!!! Input parameters passed - [All input param stuff added by AAD]
## Get input parameter of view selection. If called w/o then default to view=1
$view = $cgi->param ('view');
if ($view == "") {$view = 1};
## Get any DateInput values that were input
$DayI = $cgi->param ('DayI');
$MonthI = $cgi->param ('MonthI');
$YearI = $cgi->param ('YearI');

###!!! Previous/Clear/Next buttons? [See the file Addendum-AAD for button details.]
$Flag = $cgi->param ('flag');
if ($Flag == 9) {
     # 9 == Clear 
     $DayI="";
     $MonthI = "";
     $YearI = "";
     $Flag = '';
}
elsif ($Flag == 1) {
     # 1 == Next
    if ($view == 1){
      $DayI++;
      if ($DayI == 32) {$DayI = 1;$MonthI++;}
      if ($MonthI == 13) {$MonthI = "01";$YearI++;}
#      if ($DayI < 10) {$DayI = "0$DayI";}
      if (length($DayI) == 1) {$DayI = "0$DayI";}
      if (length($MonthI) == 1) {$MonthI = "0$MonthI";}
      $Flag=0;
    }
    elsif ($view == 2 || $view == 4){
      $MonthI++;
      if ($MonthI == 13) {$MonthI = 1;$YearI++;}
#      if ($MonthI < 10) {$MonthI = "0$MonthI";}
      if (length($MonthI) == 1) {$MonthI = "0$MonthI";}
      $Flag=0;
    }
    elsif ($view == 3){
      $YearI++;
      $Flag=0;
    }
}
elsif ($Flag == -1) {
     # -1 == Previous
    if ($view == 1){
      $DayI--;
      if ($DayI == 0) {$DayI = 31;$MonthI--;}
      if ($MonthI == 0) {$MonthI = 12;$YearI--;}
#      if ($DayI < 10) {$DayI = "0$DayI";}
      if (length($DayI) == 1) {$DayI = "0$DayI";}
      if (length($MonthI) == 1) {$MonthI = "0$MonthI";}
      $Flag=0;
    }
    elsif ($view == 2 || $view == 4){
      $MonthI--;
      if ($MonthI == 0) {$MonthI = 12;$YearI--;}
#      if ($MonthI < 10) {$MonthI = "0$MonthI";}
      if (length($MonthI) == 1) {$MonthI = "0$MonthI";}
      $Flag=0;
    }
    elsif ($view == 3){
      $YearI--;
      $Flag=0;
    }
}

if ($DayI && $MonthI && $YearI)
 {$datei = "$YearI-$MonthI-$DayI"}
else
 {$datei = ""}

### Do HTML Top Of Page display
#!!! Mod views to include explicit path to cgi-bin_dir with value from localvars.pm
print <<html;
<TITLE>Power Graph</TITLE>
<meta http-equiv="refresh" content="600" url="http://dunwellguitar.com/SolarData/power_graph.cgi?view=$view&DayI=$DayI&MonthI=$MonthI&YearI=$YearI">
<body>
<TABLE BORDER="0" CELLSPACING="1" CELLPADDING="3">
  <TR>
    <TD><FONT FACE="terminal" SIZE="2">View</FONT></TD>
    <TD><A HREF="$cgi_bin_dir/power_graph.cgi?view=1&DayI=$DayI&MonthI=$MonthI&YearI=$YearI&flag=$Flag"><FONT FACE="terminal" SIZE="2">Day</FONT></A></TD>
    <TD><A HREF="$cgi_bin_dir/power_graph.cgi?view=2&DayI=$DayI&MonthI=$MonthI&YearI=$YearI&flag=$Flag"><FONT FACE="terminal" SIZE="2">Month</FONT></A></TD>
    <TD><A HREF="$cgi_bin_dir/power_graph.cgi?view=3&DayI=$DayI&MonthI=$MonthI&YearI=$YearI&flag=$Flag"><FONT FACE="terminal" SIZE="2">Year</FONT></A></TD>
    <TD><A HREF="$cgi_bin_dir/power_graph.cgi?view=4&DayI=$DayI&MonthI=$MonthI&YearI=$YearI&$flag=$Flag"><FONT FACE="terminal" SIZE="2">Month of Day Peaks</FONT></A></TD>
  </TR>
</TABLE>

<script>
function setLocation(url){
<!-- alert ("In setLocation " + url);//-->
location.href = url;
}

<!--  from http://www.codingforums.com/archive/index.php?t-8840.html  Script for auto-tabbing entry fields -->
function nextbox(fldobj, nbox) {
if (fldobj.value.length==fldobj.maxLength) {
fldobj.form.elements[nbox].focus();
}
} 
</script> 

<form action="$cgi_bin_dir/power_graph.cgi" id="DateInput">
<fieldset>
  <input type="text" name="DayI" size="2" maxlength="2" value="$DayI" onkeyup="nextbox(this,'MonthI');">
  <input type="text" name="MonthI" size="2" maxlength="2" value="$MonthI" onkeyup="nextbox(this,'YearI');">
  <input type="text" name="YearI" size="4" maxlength="4" value="$YearI" onkeyup="nextbox(this,'DayI');">
  <input type="hidden" name="view" value="$view">
  <input type="hidden" name="flag" value="$Flag">
  Enter a <em>complete</em> date as Day, Month, Year [dd mm yyyy] or leave blank for Today.  </br>
  <input type=submit value="Apply Date Data">
  <input type="button" name="Button" value="Previous" onclick="setLocation('$cgi_bin_dir/power_graph.cgi?view=$view&DayI=$DayI&MonthI=$MonthI&YearI=$YearI&flag=-1')">
  <input type="button" name="Button" value="Clear" onclick="setLocation('$cgi_bin_dir/power_graph.cgi?view=$view&DayI=$DayI&MonthI=$MonthI&YearI=$YearI&flag=9')">
  <input type="button" name="Button" value="Next" onclick="setLocation('$cgi_bin_dir/power_graph.cgi?view=$view&DayI=$DayI&MonthI=$MonthI&YearI=$YearI&flag=1')">
  (Prev/Clear/Next only for entered dates. Day/Month roll-over on 31 days.)
</fieldset>
</form>
</body>
html

### Generate the xtics and query
## Open the data file
open(power_graph_data_fh, ">$power_graph_data_file");

## 3=Year
if ($view == 3)
{
  ## Any date input?
  if ($datei == "")
    {
     $date_string = "date +%Y";
     $year = qx($date_string);
     chop $year;
    }
    else
     {$year = $YearI;}
  $query_string="select date,kwh from totals_log where year(date) = \"$year\" ORDER BY date";
  for ($i = 1; $i <= 12; $i++)
  {
    if ($i < 10)
    {
      $label = "0".$i;
    }
    else
    {
      $label = $i;
    }

    $timestamp = "$year-$i-01";
    $timestamp = ($db->query("select unix_timestamp(\"$timestamp\")"))->fetchrow;
    if ($i == 1)
    {
      $xrange_begin = $timestamp;
    }
    elsif ($i == 12)
    {
      $xtics .= "\"$label\" $timestamp";
      $next_year = $year+1;
      $timestamp = "$next_year-01-01";
      $timestamp = ($db->query("select unix_timestamp(\"$timestamp\")"))->fetchrow;
      $xrange_end = $timestamp;
    }

    if ($i < 12)
    {
      $xtics .= "\"$label\" $timestamp, ";
    }
  }

  $xlabel = "Month";
  $xrange = "$xrange_begin:$xrange_end";
  $title = "$year";
  ##!!!+ Check to see what the Y range is for kwh per day in the year and pad with 10% to
  ##    leave room at the top of the graph for the legend
  $Maxkwh = ($db->query("select MAX(kwh) from totals_log where year(date) = \"$year\""))->fetchrow;
  if ($Maxkwh <= 0) {$Maxkwh = 1;}
  $Maxkwh = int($Maxkwh + 0.1*$Maxkwh);
  $yrange = "0:$Maxkwh";
  #!!!-
  $ylabel = "kWh";
  $ytics = "1.0";
}
## 2=Month OR Month of Day Peaks [all Month of Peaks added by AAD]

elsif ($view == 2 || $view == 4)
{
  ## Any date input?
  if ($datei == "")
    {
      $date_string = "date +%Y-%m";
      $date = qx($date_string);
      chop $date;
    }
    else
     {$date = $datei;}
  ($year, $month) = split ('-', $date);
  $date = "$year-$month-01";
  if ($view == 2)
   { $query_string="select date,kwh from totals_log where date >= \"$date\" ORDER BY date"; }
  else
#   {$query_string="select date(datetime),MAX(input_watts) from daily_log where date(datetime) = \"$date\" ORDER BY datetime";}
   {$query_string="select MAX(input_watts) from daily_log where date(datetime) = \"$date\" ORDER BY datetime";}

  ## Future year month and day to get number of days in the month, rollover for december
  $month++;
  if ($month == 13)
  {
    $year++;
    $month = 1;
  }
  $future_date = "$year-$month-01";

  $days_in_month = ($db->query("select unix_timestamp(\"$future_date\") - unix_timestamp(\"$date\")"))->fetchrow;
  $days_in_month = int($days_in_month / (60*60*24));

  ## Re-get Current or Input Year and Month
  if ($datei == "")
    {
      $date_string = "date +%Y-%m";
      $date = qx($date_string);
      chop $date;
    }
    else
     {$date = $datei;}
  ($year, $month) = split ('-', $date);
  $date = "$year-$month-01";

  $count=0;
  for ($i = 1; $i <= $days_in_month; $i++)
  {
    $date = "$year-$month-$i";
    $date_timestamp = ($db->query("select unix_timestamp(\"$date\")"))->fetchrow;
    if ($view == 4)
    {
      #Month of Day Peaks - get the data and save to the .dat file right here. Increment $count so data
      # won't get overwritten with a 0 0 0 further down.
      if ($i < 10)
      {
        $date = "$year-$month-0$i";
      }
      $DayMax = ($db->query("select MAX(input_watts) from daily_log where date(datetime) = \"$date\""))->fetchrow;
      print power_graph_data_fh "$date_timestamp $DayMax\n";
      $count++;
    }
    if ($i ==1)
    {
      $xrange_begin = $date_timestamp;
    }
    elsif ($i == $days_in_month)
    {
      $xrange_end = $date_timestamp;
    }

    if ($i < 10)
    {
      $label = "0".$i;
    }
    else
    {
      $label = $i;
    }

    $xtics .= "\"$label\" $date_timestamp, ";
  }

  chop $xtics;
  chop $xtics;

  $xlabel = "Day of the Month";
  $xrange = "$xrange_begin:$xrange_end";
  $title = "$year-$month";

  if ($view == 2)
  {
  ##!!!+ View=2, Check to see what the Y range is for kwh per day in the month and pad with 10% to
  ##    leave room at the top of the graph for the legend
  $Maxkwh = ($db->query("select MAX(kwh) from totals_log where month(date) =  \"$month\""))->fetchrow;
  if ($Maxkwh <= 0) {$Maxkwh = 1;}
  $Maxkwh = int($Maxkwh + 0.1*$Maxkwh);
  $yrange = "0:$Maxkwh";
  #!!!-
  $ylabel = "kWh";
  $ytics = "1.0";
  }
  else
  {
  ##!!!+ View=4, Peak dailys - Check to see what the Y range is for watts per day and pad with 5% to
  ##    leave room at the top of the graph for the legend
  $MaxWatt = ($db->query("select MAX(input_watts) from daily_log where month(datetime) =  \"$month\""))->fetchrow;
  if ($MaxWatt <= 0) {$MaxWatt = 1;}
  #save this for title line
  $max = $MaxWatt;
  $MaxWatt = int($MaxWatt + 0.05*$MaxWatt);
  $yrange = "0:$MaxWatt";
  #!!!-
  $ylabel = "Watts";
  $ytics = "100";
  }
}

elsif ($view == 1)
## 1=Day or Today
{
  $view = 1;
  ## Any date input?
  if ($datei == "")
    {
     $date_string = "date +%Y-%m-%d";
     $date = qx($date_string);
     chop $date;
    }
    else
     {$date = $datei;}
  ## format xtics string
  for ($i = 0; $i < 24; $i++)
  {
    if ($i < 10)
    {
      $label = "0".$i;
    }
    else
    {
      $label = $i;
    }

    $timestamp = $date." $i:00:00";
    $timestamp = ($db->query("select unix_timestamp(\"$timestamp\")"))->fetchrow;

    $xtics .= "\"$label\" $timestamp, ";
  }

  ($year, $month, $day) = split('-', $date);
  $query_string="select datetime,output_watts,input_watts,unix_timestamp(datetime) from daily_log where date(datetime) = \"$date\" ORDER BY datetime";

  $timestamp = $date." 00:00:00";
  $xrange_begin = ($db->query("select unix_timestamp(\"$timestamp\")"))->fetchrow;
  $xrange_end = $xrange_begin + 60*60*24;

  chop $xtics;
  chop $xtics;

  $xlabel = "Time";
  $title = "$year-$month-$day";
  $xrange = "$xrange_begin:$xrange_end";
  ##!!!+ Check to see what the Y range is for watts per day and pad with 5% to
  ##    leave room at the top of the graph for the legend
  $MaxWatt = ($db->query("select MAX(input_watts) from daily_log where date(datetime) =  \"$date\""))->fetchrow;
  if ($MaxWatt <= 0) {$MaxWatt = 1;}
  $MaxWatt = int($MaxWatt + 0.05*$MaxWatt);
  $yrange = "0:$MaxWatt";

  #!!!-
  $ylabel = "Watts";
  $ytics = "100";
}

###!!! Use query_string and get data from MySQL and put into the .dat file. Note that 
#   view=4 has already gotten the data
  if (view !=4)
  {
  $query = $db->query($query_string);
  $count = 0;
  $total = 0;
  while (@row = $query->fetchrow())
  {
    $count++;
    ## Day or Today
    if ($view == 1)
    {
      $timestamp = ($db->query("select unix_timestamp(\"$row[0]\")"))->fetchrow;
      print power_graph_data_fh "$timestamp $row[1] $row[2]\n";
    }
    ## Month
    elsif ($view == 2)
    {
      $date_timestamp = ($db->query("select unix_timestamp(\"$row[0]\")"))->fetchrow;
      print power_graph_data_fh "$date_timestamp $row[1]\n";
      $total += $row[1];
    }
    ## Year
    elsif ($view == 3)
    {
      $date = $row[0];
      ($year,$month,$day) = split('-', $date);

      $timestamp = ($db->query("select unix_timestamp(\"$row[0]\")"))->fetchrow;
      $date = qx($date_string);
      chop $date;
      print power_graph_data_fh "$timestamp $row[1]\n";
      $total += $row[1];
    }
  }
  }

  ## So that gnu plot is happy and an empty graph comes up instead of a broken image
  if ($count == 0)
  {
      print power_graph_data_fh "0 0 0\n";
  }

  close(power_graph_data_fh);

### TITLE
## Month
if ($view == 2)
{
  $average = $total / $count;
  ($num, $mantissa) = split ('\.', $average);
  $mantissa = substr($mantissa, 0, 3);
  $average = $num.".".$mantissa;

  $title .= " - $total kWh Total - Average $average kWh per day";
}
## Year
elsif ($view == 3)
{
  $average = $total / $count;

  ($num, $mantissa) = split ('\.', $average);
  $mantissa = substr($mantissa, 0, 3);
  $average = $num.".".$mantissa;
  $title .= " - $total kWh Total - Average $average kWh per day";
}
elsif ($view == 4)
{
  $title .= " - Greatest Maximum Value for the Month = $max";
}
### Generate the gnuplot file
open(power_graph_gnuplot_fh, ">$power_graph_gnuplot_file");
  print power_graph_gnuplot_fh "set term png\n";
#!!! RedHat png driver gives an error after "size" about "expecting..."
#   Faulty old driver even in new RHEL5. Use old driver term 
#   "picsize" and no comma. For more info see the gnuplot docs
#    http://www.gnuplot.info/docs_4.0/gnuplot.pdf
#   and the section under Commands, Set, Terminal, png{old|new}
#   I have also resized for my smaller screen realestate.
#  print power_graph_gnuplot_fh "set term png picsize 960 480\n";
  print power_graph_gnuplot_fh "set term png picsize 840 420\n";
#  print power_graph_gnuplot_fh "set term png size 960,480\n";
  print power_graph_gnuplot_fh "set output \"$power_graph_image\"\n";
  print power_graph_gnuplot_fh "set key left top\n";
  print power_graph_gnuplot_fh "set title \"Power Graph [$title]\"\n";
  print power_graph_gnuplot_fh "set xtics ($xtics)\n";
  print power_graph_gnuplot_fh "set xlabel \"$xlabel\"\n";
  print power_graph_gnuplot_fh "set ylabel \"$ylabel\"\n";
  print power_graph_gnuplot_fh "set xrange [$xrange]\n";
  print power_graph_gnuplot_fh "set yrange [$yrange]\n";
  print power_graph_gnuplot_fh "set y2range [$yrange]\n";
  print power_graph_gnuplot_fh "set ytics $ytics\n";
  print power_graph_gnuplot_fh "set y2tics $ytics\n";
  print power_graph_gnuplot_fh "set grid\n";
  if ($view == 1)
  {
    print power_graph_gnuplot_fh "plot \"$power_graph_data_file\" using 1:3 with boxes fs solid 0.5 ti \"DC Solar Panel Input\", \"$power_graph_data_file\" using 1:2 with boxes fs solid 0.5 ti \"AC Inverter Output\"";
  }
  elsif ($view == 2)
  {
    print power_graph_gnuplot_fh "plot \"$power_graph_data_file\" using 1:2 with boxes fs solid 0.5 ti \"kWh Generated\"";
  }
  elsif ($view == 3)
  {
    print power_graph_gnuplot_fh "plot \"$power_graph_data_file\" using 1:2 with boxes fs solid 0.7 ti \"kWh Generated\"";
  }
  elsif ($view == 4)
  {
    print power_graph_gnuplot_fh "plot \"$power_graph_data_file\" using 1:2 with boxes fs solid 0.5 ti \"DC Panel Input-Peak Vals\"";
  }

close(power_graph_gnuplot_fh);

qx(gnuplot $power_graph_gnuplot_file);

print <<HTML;
<CENTER>
HTML

#!!! mod to inlcude explicit path from localvars.
print "<BR><IMG SRC=\"$cgi_bin_dir/power_graph_image.cgi\">";

print <<HTML;
<BR><BR>
<FONT FACE="terminal" SIZE="2"> (New data avilable every 10 minutes)</FONT>
</CENTER>
HTML

$count = ($db->query("select count+1 from visitors"))->fetchrow;
$db->query("update visitors set count=$count");
