#!/usr/bin/perl
############################################
## This software is licensed under the LGPL.
## Visit http://solar.js.cx for more info.
############################################
#!!!+ This file is modified by Alan Dunwell - http://dunwellguitar.com/solardata/
#   Look for the #!!! flag for Dunwell Mods, but note that not all may be flagged. For
#   those interested, do a side-by-side comparison with Justin's original files.
#   Last Mod - 03/06/2008
#!!!-

use Mysql;
use CGI;
use localvars;

$db = Mysql->Connect ($mysql_host, $mysql_db, $mysql_user, $mysql_passwd);

$cgi = new CGI;
print $cgi->header;

#!!! Maybe this should be moved to the localvars.pm?
$system_cost = 13583.00;

$cost_graph_data_file = "/tmp/cost_graph.dat";
$cost_graph_gnuplot_file = "/tmp/cost_graph.gplot";
$cost_graph_line_width = 1;
$cost_graph_image = "/tmp/cost_graph.png";

$view = $cgi->param ('view');

print <<html;
<TITLE>Cost Graph</TITLE>
html



## Generate the data file
open(cost_graph_data_fh, ">$cost_graph_data_file");

$query_string="select date,kwh,kwh_cost,unix_timestamp(date) from totals_log ORDER BY date";

$xtics = "";
$total_kwh = 0;
$total_saved = 0;
$query = $db->query($query_string);
while (@row = $query->fetchrow())
{
  $date = $row[0];
  $date =~ s/-/ /g;
  ($year,$month,$day) = split(' ', $date);
 
  if ($day == 0 && $hour == 0 && $minute == 0 || $xtics eq "")
  {
    if ($xtics ne "")
    {
      $xtics .= ", ";
    }
    $xtics .= "\"$month/$year\" $row[3]";
  }

  $total_kwh += $row[1];
  $total_saved += $row[1]*$row[2];
  print cost_graph_data_fh "$row[3] $total_saved\n";
}

($num, $mantissa) = split ('\.', $total_saved);
$mantissa = substr($mantissa, 0, 2);
$total_saved = $num.".".$mantissa;

$net_savings = $total_saved - $system_cost;
($num, $mantissa) = split ('\.', $net_savings);
$mantissa = substr($mantissa, 0, 2);
$net_savings = $num.".".$mantissa;

if ($net_savings < 0)
{
  $net_color = "red";
}
else
{
  $net_color = "black";
}

($total_kwh, $mantissa) = split ('\.', $total_kwh);

#!!!+ I have modified the calculations for the various equivilants shown across
#  the top of the graph, and added in a few more just for the fun of it.
# Comparison values were calculated with the converter tool at
#  http://www.eia.doe.gov/kids/energyfacts/science/energy_calculator.html
# but I've left in Justin's lines just in case mine prove wrong in some way.

# Oil - One barrel crude = 1699.88277kWh
#$oil_barrels = $total_kwh * 0.58 / 286.6;
$oil_barrels = $total_kwh / 1699.88;
($num, $mantissa) = split ('\.', $oil_barrels);
$mantissa = substr($mantissa, 0, 2);
$oil_barrels = $num.".".$mantissa;

# Coal - one Short Ton = 6082.64947kWh, one Metric Ton = 6704.97878kWh
#$coal_tonnage = $total_kwh / 2000.0;
$coal_tonnage = $total_kwh / 6082.65;
($num, $mantissa) = split ('\.', $coal_tonnage);
$mantissa = substr($mantissa, 0, 2);
$coal_tonnage = $num.".".$mantissa;

# Gasoline - one gallon = 36.3482kWh
$gas_gallons = $total_kwh / 36.35;
($num, $mantissa) = split ('\.', $gas_gallons);
$mantissa = substr($mantissa, 0, 2);
$gas_gallons = $num.".".$mantissa;

# Twinkies = 150 kilocalories/ea = 0.17455kWh
$twinkies = $total_kwh / 0.1755;
($num, $mantissa) = split ('\.', $twinkies);
$twinkies = $num;

# Oreos = 55 kilocalories/ea = 0.064kWh
$oreos = $total_kwh /0.064;
($num, $mantissa) = split ('\.', $oreos);
$oreos = $num;
#!!!-

print <<HTML;
<TABLE BORDER="0" CELLSPACING="1" CELLPADDING="8">
  <TR>
    <TD><FONT FACE="terminal" SIZE="2">Total Saved:</FONT>
    <FONT FACE="terminal" SIZE="2" COLOR="ForestGreen">\$$total_saved</FONT></TD>
    <TD><FONT FACE="terminal" SIZE="2">Net Savings:</FONT>
    <FONT FACE="terminal" SIZE="2" COLOR="$net_color">\$$net_savings</FONT></TD>
    <TD><FONT FACE="terminal" SIZE="2">Total kWh:</FONT>
    <FONT FACE="terminal" SIZE="2" COLOR="DarkGreen ">$total_kwh</FONT></TD>
    <TD><FONT FACE="terminal" SIZE="2">Oil Barrels:</FONT>
    <FONT FACE="terminal" SIZE="2" COLOR="blue">$oil_barrels</FONT></TD>
    <TD><FONT FACE="terminal" SIZE="2">Coal Tonnage(Short Ton):</FONT>
    <FONT FACE="terminal" SIZE="2" COLOR="black">$coal_tonnage</FONT></TD>
    <TD><FONT FACE="terminal" SIZE="2">Gallons of Gas:</FONT>
    <FONT FACE="terminal" SIZE="2" COLOR="DeepPink">$gas_gallons</FONT></TD>
    <TD><FONT FACE="terminal" SIZE="2">Twinkies:</FONT>
    <FONT FACE="terminal" SIZE="2" COLOR="GoldenRod ">$twinkies</FONT></TD>
    <TD><FONT FACE="terminal" SIZE="2">Oreos:</FONT>
    <FONT FACE="terminal" SIZE="2" COLOR="FireBrick ">$oreos</FONT></TD>
  </TR>
</TABLE>
HTML


close(cost_graph_data_fh);

$timestamp = scalar localtime;

## Generate the gnuplot file
open(cost_graph_gnuplot_fh, ">$cost_graph_gnuplot_file");
  print cost_graph_gnuplot_fh "set term png\n";
#!!! RedHat png driver gives an error after "size" about "expecting..."
#   Use old driver term "picsize" and no comma. NOTE: the "size" command 
#    is now depreciated in gnuplot.
#  Also changed the plot size to fit my smaller windows better in full screen mode.
#  print cost_graph_gnuplot_fh "set term png size 960,480\n";
  print cost_graph_gnuplot_fh "set term png picsize 822 420\n";
  print cost_graph_gnuplot_fh "set output \"$cost_graph_image\"\n";
  print cost_graph_gnuplot_fh "set key left top\n";
  print cost_graph_gnuplot_fh "set title \"Cost Graph - $timestamp\"\n";
  print cost_graph_gnuplot_fh "set xlabel \"Time\"\n";
  print cost_graph_gnuplot_fh "set ylabel \"Money Saved - \$\"\n";
  print cost_graph_gnuplot_fh "set yrange [0:$total_saved]\n";
  print cost_graph_gnuplot_fh "set xtics ($xtics)\n";
#  print cost_graph_gnuplot_fh "set ytics [10]\n";
  print cost_graph_gnuplot_fh "set grid\n";
  print cost_graph_gnuplot_fh "plot \"$cost_graph_data_file\" using 1:2 with lines lw 3 ti \"Running Total\"";
#  print cost_graph_gnuplot_fh "plot \"$cost_graph_data_file\" using 1:2 with boxes fs solid 0.5 ti \"Running Total\"";
#  print cost_graph_gnuplot_fh "plot \"$cost_graph_data_file\" using 1:2 smooth csplines lw 3 ti \"Running Total\"";
#  print cost_graph_gnuplot_fh "plot \"$cost_graph_data_file\" using 1:2 with boxes fs solid 0.5 ti \"Power Fit\", \"$cost_graph_data_file\" using 1:2 smooth csplines lw 3 ti \"Running Total\"";
close(cost_graph_gnuplot_fh);

qx(gnuplot $cost_graph_gnuplot_file);

print <<HTML;
<CENTER>
HTML
#!!! mod to inlcude explicit path form localvars.
print "<BR><IMG SRC=\"$cgi_bin_dir/cost_graph_image.cgi\">";

$count = ($db->query("select count+1 from visitors"))->fetchrow;
$db->query("update visitors set count=$count");
